<?php
/*======================================================================*\
|| #################################################################### ||
|| # Helpful Answers Admin Script version 1.6.0
|| # Addon Copyright Ted Sindzinski
|| # Developed exclusively for vBulletin 3.7 and 3.8 
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2006 Jelsoft Enterprises Ltd. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('CVS_REVISION', '$RCSfile$ - $Revision: 14678 $');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array('cpuser', 'user', 'cprofilefield');
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_user.php');

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminusers'))
{
	print_cp_no_permission();
}

$vbulletin->input->clean_array_gpc('r', array(
	'avatarid' => TYPE_INT,
	'userid'   => TYPE_INT,
));

// ############################# LOG ACTION ###############################
log_admin_action(!empty($vbulletin->GPC['userid']) ? 'user id = ' . $vbulletin->GPC['userid'] : '');

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

print_cp_header($vbphrase['user_manager']);

if (!$_REQUEST['do']){
	$_REQUEST['do'] = 'helpfulanswers';
}

// ############################# log searching #########################
if ($_REQUEST['do'] == 'helpfulanswers')
{

	print_form_header('helpfulanswers', 'show_helpfulanswers');
	print_table_header('Helpful Answer Statistics');
	print_description_row($vbphrase['please_input_referral_dates']);
	print_time_row($vbphrase['start_date'], 'startdate', TIMENOW - 24 * 60 * 60 * 31, 1, 0, 'middle');
	print_time_row($vbphrase['end_date'], 'enddate', TIMENOW, 1, 0, 'middle');
	print_label_row('Number of posts rated', '<select name="number" tabindex="1" class="bginput"><option value="">---- Any Number ----</option><option value="5">Over 5</option><option value="10">Over 10</option><option value="25">Over 25</option><option value="50">Over 50</option><option value="100">Over 100</option><option value="250">Over 250</option><option value="500">Over 500</option></select>');
	print_input_row($vbphrase['username'], 'uname', $uname, 0);
	print_input_row('Post ID', 'postid', $postid, 0);
	print_table_break();

	print_table_header('Result Display Options');
	print_label_row($vbphrase['order_by'], '
		<select name="orderby" tabindex="1" class="bginput">
		<option value="username" selected="selected">' . 	$vbphrase['username'] . '</option>
		<option value="count" selected="selected">Total Ratings</option>
		<option value="positive">Positive Ratings</option>
		<option value="percentage">Positive Percentage</option>
		</select>
		<select name="direction" tabindex="1" class="bginput">
		<option value="">' . $vbphrase['ascending'] . '</option>
		<option value="DESC">' . $vbphrase['descending'] . '</option>
		</select>
	', '', 'top', 'orderby');
	print_label_row('Number of users to show:', '
	<select name="limitnumber" tabindex="2" class="bginput">
	<option value="10">10 Per Page</option>
	<option value="25" selected="selected">25 Per Page</option>
	<option value="50">50 Per Page</option>
	<option value="100">100 Per Page</option>
	<option value="500">100 Per Page</option>
	<option value="1000">1000 Per Page</option>
	<option value="9999999">All Members At Once</option>
	</select>
	');
	
	print_submit_row($vbphrase['find']);

}

// ############################# show ratings #########################
if ($_POST['do'] == 'show_helpfulanswers')
{

	$vbulletin->input->clean_array_gpc('p', array(
		'limitstart'  => TYPE_UINT,
		'limitnumber'	=> TYPE_UINT,
		'orderby'     => TYPE_STR,
		'direction'   => TYPE_STR,
		'startdate' 	=> TYPE_ARRAY_INT,
		'enddate'   	=> TYPE_ARRAY_INT,
		'number' 			=> TYPE_INT,
		'uname'				=> TYPE_STR,
		'postid' 			=> TYPE_INT,
	));
	
	switch($vbulletin->GPC['orderby'])
	{
		case 'username':
		case 'count':
		case 'positive':
		case 'percentage':
			break;
		default:
			$vbulletin->GPC['orderby'] = 'count';
	}

	if ($vbulletin->GPC['direction'] != 'DESC')
	{
		$vbulletin->GPC['direction'] = 'ASC';
	}

	if (empty($vbulletin->GPC['limitstart']))
	{
		$vbulletin->GPC['limitstart'] = 0;
	}
	else
	{
		$vbulletin->GPC['limitstart']--;
	}

	if (empty($vbulletin->GPC['limitnumber']) OR $vbulletin->GPC['limitnumber'] == 0)
	{
		$vbulletin->GPC['limitnumber'] = 25;
	}
	$limitfinish = $vbulletin->GPC['limitstart'] + $vbulletin->GPC['limitnumber'];
	
	$query_filter = '';
	$having_filter = '';
	if ($vbulletin->GPC['uname'])
	{
		$uid = $db->query_first_slave("SELECT userid FROM " . TABLE_PREFIX . "user WHERE username = '". $vbulletin->GPC['uname'] ."' ");
		$userid = $uid['userid'];
		if($userid){ $query_filter .= " AND user.userid = '". $userid ."' "; }
	}
	if ($vbulletin->GPC['postid'])
	{
		$query_filter .= " AND helpfulanswer.postid = $postid ";
	}
	if ($vbulletin->GPC['number'])
	{
		$having_filter = 'HAVING count > '. intval($vbulletin->GPC['number']) .' ';
	}

	require_once(DIR . '/includes/functions_misc.php');
	if ($vbulletin->GPC['startdate']['month'])
	{
		$vbulletin->GPC['startdate'] = vbmktime(intval($vbulletin->GPC['startdate']['hour']), intval($vbulletin->GPC['startdate']['minute']), 0, intval($vbulletin->GPC['startdate']['month']), intval($vbulletin->GPC['startdate']['day']), intval($vbulletin->GPC['startdate']['year']));
		$datequery = " AND helpfulanswer.dateline >= " . $vbulletin->GPC['startdate'];
		$datestart = vbdate($vbulletin->options['dateformat'] . ' ' .  $vbulletin->options['timeformat'], $vbulletin->GPC['startdate']);
	}
	else
	{
		$vbulletin->GPC['startdate'] = 0;
	}

	if ($vbulletin->GPC['enddate']['month'])
	{
		$vbulletin->GPC['enddate'] = vbmktime(intval($vbulletin->GPC['enddate']['hour']), intval($vbulletin->GPC['enddate']['minute']), 0, intval($vbulletin->GPC['enddate']['month']), intval($vbulletin->GPC['enddate']['day']), intval($vbulletin->GPC['enddate']['year']));
		$datequery .= " AND helpfulanswer.dateline <= " . $vbulletin->GPC['enddate'];
		$dateend = vbdate($vbulletin->options['dateformat'] . ' ' . $vbulletin->options['timeformat'], $vbulletin->GPC['enddate']);
	}
	else
	{
		$vbulletin->GPC['enddate'] = 0;
	}

	if ($datestart OR $dateend)
	{
		$refperiod = construct_phrase($vbphrase['x_to_y'], $datestart, $dateend);
	}
	else
	{
		$refperiod = $vbphrase['all_time'];
	}

	$countusers = $db->query_first("
		SELECT COUNT(helpfulanswerid) AS count
		FROM " . TABLE_PREFIX . "helpfulanswer AS helpfulanswer
		INNER JOIN " . TABLE_PREFIX . "user AS user ON(helpfulanswer.userid = user.userid)
		WHERE helpfulanswer.helpfulanswerid <> 0
			$query_filter
			$datequery
		GROUP BY helpfulanswer.userid
			$having_filter
	");

	$users = $db->query_read("
		SELECT COUNT(helpfulanswerid) AS count, sum(helpfulanswer.yesno) as positive, ((sum(helpfulanswer.yesno)/count(*))*100) as percentage, user.username, user.userid
		FROM " . TABLE_PREFIX . "helpfulanswer AS helpfulanswer
		INNER JOIN " . TABLE_PREFIX . "user AS user ON(helpfulanswer.userid = user.userid)
		WHERE helpfulanswer.helpfulanswerid <> 0
			$query_filter
			$datequery
		GROUP BY user.userid
		$having_filter
		ORDER BY " . $db->escape_string($vbulletin->GPC['orderby']) . " " . $db->escape_string($vbulletin->GPC['direction']) . "
		LIMIT " . $vbulletin->GPC['limitstart'] . ", " . $vbulletin->GPC['limitnumber']
	);

	if (!$db->num_rows($users))
	{
		define('CP_REDIRECT', 'helpfulanswers.php');
		print_stop_message('no_helpfuls_matched_your_query');	
	}
	else
	{

		$tcount = 0;
		$tpositive = 0;

		print_form_header('helpfulanswers', 'show_helpfulanswers');
		print_table_header('Helpful Answer Stats' . ' - ' .	$refperiod,6);
		print_table_break();
		print_table_header(
		construct_phrase(
			$vbphrase['showing_users_x_to_y_of_z'],
			($vbulletin->GPC['limitstart'] + 1),
			iif($limitfinish > $countusers['count'], $countusers['count'], $limitfinish),
			$countusers['count']
		), 6);
		
		if($vbulletin->options['helpans_stats_ten']){
			print_cells_row(array($vbphrase['username'], 'Total Ratings', 'Average Rating', 'Total Points',  'Rating Detail', 'Clear Ratings'), 1);
		} else {
			print_cells_row(array($vbphrase['username'], 'Total Ratings', 'Positive Ratings', 'Positive Percentage', 'Rating Detail', 'Clear Ratings'), 1);
		}
		
		while ($user=$db->fetch_array($users))
		{
			
			$tcount += $user['count'];
			$tpositive += $user['positive'];
			$userid = $user['userid'];
			$username = $user['username'];
			
			if($vbulletin->options['helpans_stats_ten']){
				$avgranking = $user['positive'] / $user['count'];
				print_cells_row(array('<a href="./user.php?do=edit&u='.$userid.'">'.$username.'</a>', $user['count'],vb_number_format($avgranking),$user['positive'],'<a href="./helpfulanswers.php?do=show_helpfuluser&userid='.$userid.'">view</a>','<a href="./helpfulanswers.php?do=remove_all&userid='.$userid.'">[x]</a>'));
			} else {
				print_cells_row(array('<a href="./user.php?do=edit&u='.$userid.'">'.$username.'</a>', vb_number_format($user['count']),vb_number_format($user['positive']),vb_number_format($user['percentage'])."%",'<a href="./helpfulanswers.php?do=show_helpfuluser&userid='.$userid.'">view</a>','<a href="./helpfulanswers.php?do=remove_all&userid='.$userid.'">[x]</a>'));
			}
			
		}
		
		$tpercent = $tpositive / $tcount * 100;
		
		if($vbulletin->options['helpans_stats_ten']){
			$taverage = $tpositive / $tcount;
			print_cells_row(array('',$tcount,$taverage,'','',''),1);
		} else {
			print_cells_row(array('',$tcount,$tpositive,round($tpercent)."%",'',''),1);
		}
	
		if($vbulletin->GPC['number']){ construct_hidden_code('number', $vbulletin->GPC['number']); }
		if($vbulletin->GPC['uname']){ construct_hidden_code('uname', $vbulletin->GPC['uname']); } 
		if($vbulletin->GPC['postid']){ construct_hidden_code('postid', $vbulletin->GPC['postid']); }
		
		construct_hidden_code('startdate', $vbulletin->GPC['startdate']);
		construct_hidden_code('enddate', $vbulletin->GPC['enddate']);	
		construct_hidden_code('limitnumber', $vbulletin->GPC['limitnumber']);
		construct_hidden_code('orderby', $vbulletin->GPC['orderby']);
		construct_hidden_code('direction', $vbulletin->GPC['direction']);
	
		if ($vbulletin->GPC['limitstart'] == 0 AND $countusers['count'] > $vbulletin->GPC['limitnumber'])
		{
			construct_hidden_code('limitstart', $vbulletin->GPC['limitstart'] + $vbulletin->GPC['limitnumber'] + 1);
			print_submit_row($vbphrase['next_page'], 0, 6);
		}
		else if ($limitfinish < $countusers['count'])
		{
			construct_hidden_code('limitstart', $vbulletin->GPC['limitstart'] + $vbulletin->GPC['limitnumber'] + 1);
			print_submit_row($vbphrase['next_page'], 0, 6, $vbphrase['prev_page'], '', true);
		}
		else if ($vbulletin->GPC['limitstart'] > 0 AND $limitfinish >= $countusers['count'])
		{
			print_submit_row($vbphrase['first_page'], 0, 6, $vbphrase['prev_page'], '', true);
		}
		else
		{
			print_table_footer();
		}
		
	}
}

// ############################# start by user #########################
if ($_REQUEST['do'] == 'show_helpfuluser')
{
	
	$vbulletin->input->clean_array_gpc('p', array(
		'userid' 	=> TYPE_INT,
	));
	
	if (!$vbulletin->GPC['userid'])
	{
		print_stop_message('invalid_user_specified');
	}
	
	// get username
	$uid = $db->query_first_slave("SELECT username FROM " . TABLE_PREFIX . "user WHERE userid = '". $vbulletin->GPC['userid'] ."' ");
	$username = $uid['username'];
	
	// build table headers
	print_form_header('', '');
	print_table_header('Helpful Answer Details for '.$username.'',4);
	print_cells_row(array('Thread Title', 'Rating', 'Post', 'Delete'), 1);
	
	// loop all the guts
	$hanswers = $db->query_read("
		SELECT ha.helpfulanswerid,ha.postid,ha.yesno,thread.threadid,thread.title as ttitle
		FROM " . TABLE_PREFIX . "helpfulanswer AS ha		
		INNER JOIN " . TABLE_PREFIX . "post AS post ON(ha.postid = post.postid)
		INNER JOIN " . TABLE_PREFIX . "thread AS thread ON(post.threadid = thread.threadid)
		WHERE ha.userid = ". $vbulletin->GPC['userid'] ."
	");

	while ($hanswer=$db->fetch_array($hanswers))
	{
		
		if($vbulletin->options['helpans_stats_ten']){
			$rating = $hanswer['yesno'];
			$total = $total + $hanswer['yesno'];
			$cnt++;
		} else if($hanswer['yesno']){
			$rating = 'Helpful';
		} else {
			$rating = 'Not Helpful';
		}
		
		$postid = $hanswer['postid'];
		$threadid = $hanswer['threadid'];
		$title = $hanswer['ttitle'];
		$hid = $hanswer['helpfulanswerid'];
		
		print_cells_row(array('<a href="../showthread.php?t='.$threadid.'" target="_blank">'.$title.'</a>', $rating, '<a href="../showpost.php?p='.$postid.'&postcount=1"  target="_blank">view</a>', '<a href="./helpfulanswers.php?do=remove&hid='.$hid.'">[x]</a>'));

	}	
	
	if($vbulletin->options['helpans_stats_ten']){
		
		$average = $total / $cnt;
		print_cells_row(array('', $average, '', ''), 1);
		
	}
	
	print_table_footer();	
		
}

// ###################### Start Remove Individual #######################
if ($_REQUEST['do'] == 'remove')
{
	
	$vbulletin->input->clean_array_gpc('r', array(
		'hid' => TYPE_INT
	));
	
	if (!$vbulletin->GPC['hid'])
	{
		print_stop_message('invalid_helpfulanswer_specified');
	}	
	
	print_form_header('helpfulanswers', 'kill');
	construct_hidden_code('hid', $vbulletin->GPC['hid']);
	print_table_header(construct_phrase($vbphrase['confirm_deletion_x'], 'Helpful Answers'));
	print_description_row("
		<blockquote><br />
		Are you sure you wish to remove this member's rating? Ratings should only be removed in the event of abuse!
		<br /></blockquote>\n\t");
	print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
	
}

// ###################### Start Kill Individual #######################
if ($_POST['do'] == 'kill')
{
	
	$vbulletin->input->clean_array_gpc('p', array(
		'hid' => TYPE_INT
	));
	
	if (!$vbulletin->GPC['hid'])
	{
		print_stop_message('invalid_helpfulanswer_specified');
	}
	
	// get the postid
	$ha = $db->query_first_slave("SELECT postid,yesno FROM " . TABLE_PREFIX . "helpfulanswer WHERE helpfulanswerid = '". $vbulletin->GPC['hid'] ."' ");
	if(!$ha['postid']){
		print_stop_message('no_helpfuls_matched_your_query');
	}
	
	// update the post record --> remove positive
	if($ha['yesno']){ $db->query_write("UPDATE " . TABLE_PREFIX . "helpfulpost SET totalrank=totalrank-1, goodrank=goodrank-1 WHERE postid = " . $ha['postid']); }
	
	// update the post record --> remove negative
	else { $db->query_write("UPDATE " . TABLE_PREFIX . "helpfulpost SET totalrank=totalrank-1 WHERE postid = " . $ha['postid']); }
	
	// delete the ranking
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "helpfulanswer WHERE helpfulanswerid = " . $vbulletin->GPC['hid']);
	
	define('CP_REDIRECT', 'helpfulanswers.php');
	print_stop_message('helpfulanswers_removed_one');
	
}

// ###################### Start Remove Individual #######################
if ($_REQUEST['do'] == 'remove_all')
{
	
	$vbulletin->input->clean_array_gpc('r', array(
		'userid' => TYPE_INT
	));
	
	if (!$vbulletin->GPC['userid'])
	{
		print_stop_message('invalid_user_specified');
	}

	print_form_header('helpfulanswers', 'kill_all');
	construct_hidden_code('userid', $vbulletin->GPC['userid']);
	print_table_header(construct_phrase($vbphrase['confirm_deletion_x'], 'Helpful Answers'));
	print_description_row("
		<blockquote><br />
		Are you sure you wish to remove ALL of this member's ratings? <br /><br />
		Note: This can be an intensive server process if a member has many rankings.
		<br /></blockquote>\n\t");
	print_submit_row($vbphrase['yes'], 0, 2, $vbphrase['no']);
	
}

// ###################### Start Kill Individual #######################
if ($_POST['do'] == 'kill_all')
{
	
	$vbulletin->input->clean_array_gpc('p', array(
		'userid' => TYPE_INT
	));
	
	if (!$vbulletin->GPC['userid'])
	{
		print_stop_message('invalid_user_specified');
	}
	
	$helpfulanswers = $db->query_read("
		SELECT helpfulanswerid,postid,yesno
		FROM " . TABLE_PREFIX . "helpfulanswer 
		WHERE userid = " . $vbulletin->GPC['userid']
	);
	if (!$db->num_rows($helpfulanswers))
	{		
		print_stop_message('no_helpfuls_matched_your_query');	
	}
	while ($helpfulanswer=$db->fetch_array($helpfulanswers))
	{
	
		// got a record, time to clean it up
		if($helpfulanswer['helpfulanswerid'] AND $helpfulanswer['postid']){
	
			echo "Cleaning up record: ". $helpfulanswer['helpfulanswerid'] ." / ". $helpfulanswer['postid'] ."...<br>";
	
			// update the post record --> remove positive
			if($helpfulanswer['yesno']){ $db->query_write("UPDATE " . TABLE_PREFIX . "helpfulpost SET totalrank=totalrank-1, goodrank=goodrank-1 WHERE postid = " . $helpfulanswer['postid']); echo "Removed good rating.<br>"; }
			
			// update the post record --> remove negative
			else { $db->query_write("UPDATE " . TABLE_PREFIX . "helpfulpost SET totalrank=totalrank-1 WHERE postid = " . $helpfulanswer['postid']); echo "Removed bad rating.<br>"; }
		
			// delete the ranking
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "helpfulanswer WHERE helpfulanswerid = " . $helpfulanswer['helpfulanswerid']);
						
		}
	
	}
	
	
	define('CP_REDIRECT', 'helpfulanswers.php');
	print_stop_message('helpfulanswers_removed_all');
	
}

// ############################# bulk screen #########################
if ($_REQUEST['do'] == 'bulk')
{

	print_form_header('helpfulanswers', 'do_bulk');
	print_table_header('Helpful Answers - Bulk Forum Enabling');
	print_description_row('Enable or Disable the Helpful Answers System in multiple forums.');
	print_table_break();
			
	print_table_header('Bulk Function');
	print_yes_no_row('Yes to enable; No to disable.', 'eord');
	
	print_table_header('Forum Selection');
	print_description_row('Select which forums to bulk update. For example, you may specify a list of forums or all forums except for certain ones.');
	print_input_row('Change in Select Forums (i.e. 1,4,6,10)', 'eforumids', $eforumids, 0);
	print_input_row('Change In ALL Forums EXCECPT (i.e. 1,4,6,10)', 'dforumids', $dforumids, 0);
	print_checkbox_row('Change In ALL Forums', 'allforums', 0, -1, 'Update All Forums', '');
	
	print_submit_row('Do Bulk Changes');

}


// ###################### Start Kill Individual #######################
if ($_POST['do'] == 'do_bulk')
{
	
	$vbulletin->input->clean_array_gpc('p', array(
		'eord' 			=> TYPE_INT,
		'allforums' 	=> TYPE_INT,
		'eforumids'		=> TYPE_STR,
		'dforumids'		=> TYPE_STR,
	));
	
	if(!$vbulletin->GPC['allforums'] AND !$vbulletin->GPC['dforumids'] AND !$vbulletin->GPC['eforumids']){
		print_stop_message('helpfulanswers_bulk_none');
	}
	
	if($vbulletin->GPC['eord']){ $eord = "1"; }
	else { $eord = "0"; }
	
	// change all forums
	if($vbulletin->GPC['allforums']){
		$db->query_write("UPDATE " . TABLE_PREFIX . "forum SET helpfulanswerbits = ".$eord);
	}
	
	// change all forums EXCEPT a few
	else if($vbulletin->GPC['dforumids']){
		$db->query_write("UPDATE " . TABLE_PREFIX . "forum SET helpfulanswerbits = ".$eord." WHERE forumid NOT IN (".$vbulletin->GPC['dforumids'].")");
	}
	
	// only change some forums
	else if($vbulletin->GPC['eforumids']){
		$db->query_write("UPDATE " . TABLE_PREFIX . "forum SET helpfulanswerbits = ".$eord." WHERE forumid IN (".$vbulletin->GPC['eforumids'].")");
	}	
	
	// update the bitfields so the world sees the changes
	require_once(DIR . '/includes/class_bitfield_builder.php');
	$myobj =& vB_Bitfield_Builder::init();
	$myobj->save($db);
	build_forum_permissions();
	
	define('CP_REDIRECT', 'helpfulanswers.php?do=bulk');
	print_stop_message('helpfulanswers_bulkdone');
	
}

print_cp_footer();

/*======================================================================*\
|| ####################################################################
|| Ta Da!
|| ####################################################################
\*======================================================================*/
?>